 ; Ŀ
 ;   Scaler - scale a drawing up to the real rather than the plotted size. 
 ;   Copyright 1993, 1998, 2003 by Rocket Software Ltd.                    
 ;   Emu-proofing your work place?                                         
 ;   For best results try Rocket Emu-Filters.                              
 ; 
 (DEFUN C:SCALER (/ ok ss gr sn)
  (setvar "cmdecho" 0)
  (setq ok t)
 ; Ŀ
 ;   Check to see if Dimscale = 1.                                         
 ; 
  (setq dims (rtos (setq dim (getvar "dimscale"))))
  (if (/= dim 1)
      (progn
           (setq ok ())
           (while (or (= (substr dims (strlen dims)) "0")
                      (= (substr dims (strlen dims)) "."))
                  (setq dims (substr dims 1 (- (strlen dims) 1))))
           (write-line (strcat "Dimscale is set to " dims))
           (write-line "Drawing may already be scaled.")
           (setq rr (getstring "Continue? <N>: "))
           (if (or (= rr "N") (= rr "n") (= rr ""))
               (progn (write-line "Probably a wise decision."))
               (setq ok t))))
 ; Ŀ
 ;   Get a scale factor.                                                   
 ; 
  (if ok
     (progn
          (setq ss (getreal "New Scale Factor: "))
 ; Ŀ
 ;   Set variables.                                                        
 ; 
          (setvar "dimscale" ss)
          (setvar "filletrad" (* ss 3.0))
          (setvar "ltscale" (* ss 10.0))
          (setvar "textsize" (* ss 2.5))
          (setvar "snapunit" (list ss ss))
          (setq gr (* ss 10))
          (setvar "gridunit" (list gr gr))
 ; Ŀ
 ;   Scale the drawing.                                                    
 ; 
          (command "zoom" "a")
          (command "scale" "c" (getvar "extmin") (getvar "extmax")
                           "" (getvar "extmin") ss)
 ; Ŀ
 ;   Reset limits.                                                         
 ;   Knock the last number off the value in Extmin and Extmax, since       
 ;   Limmin and Limmax are 2D points.                                      
 ; 
          (command "zoom" "e")
          (setq max (getvar "extmax"))
          (setq min (getvar "extmin"))
          (setvar "limmax" (list (car max) (cadr max)))
          (setvar "limmin" (list (car min) (cadr min)))
 ; Ŀ
 ;   Offset the limits.                                                    
 ; 
          (setvar "limmax" (polar (getvar "limmax") (/ pi 4) 1.4142135))
          (setvar "limmin" (polar (getvar "limmin") (* pi 1.25) 1.4142135))
 ; Ŀ
 ;   And end.                                                              
 ; 
          (setq ss (rtos ss))
          (setq oc ())
          (while (and (or (= (substr ss (strlen ss)) "0")
                          (= (substr ss (strlen ss)) "."))
                      (= oc ()))
                 (if (= (substr ss (strlen ss)) ".") (setq oc t))
                     (setq ss (substr ss 1 (- (strlen ss) 1))))
          (write-line (strcat "Drawing scale set to " ss "."))))
 (princ))